require('dotenv').config();
const express = require('express');
const cors = require('cors');
const path = require('path');
const config = require('./config');
const db = require('./models');

const app = express();

// Ensure upload directories exist
const fs = require('fs');
[config.uploadPath, config.uploadExcelPath].forEach(dir => {
  if (!fs.existsSync(dir)) {
    fs.mkdirSync(dir, { recursive: true });
  }
});

app.use(cors({ origin: true, credentials: true }));
app.use(express.json());
app.use(express.urlencoded({ extended: true }));

// API routes
app.use('/api/auth', require('./routes/auth'));
app.use('/api/mobile', require('./routes/mobile'));
app.use('/api', require('./routes/index'));

app.get('/api/health', (req, res) => {
  res.json({ status: 'ok', message: 'Rehman Electronics API' });
});

app.use((err, req, res, next) => {
  console.error(err.stack);
  res.status(err.status || 500).json({
    success: false,
    message: err.message || 'Internal server error'
  });
});

db.sequelize.authenticate()
  .then(() => {
    console.log('Database connected');
    return app.listen(config.port);
  })
  .then(() => {
    console.log(`Server running on http://localhost:${config.port}`);
  })
  .catch(err => {
    console.error('Unable to start:', err);
    process.exit(1);
  });
