const bcrypt = require('bcrypt');
const { body, validationResult } = require('express-validator');
const db = require('../models');

exports.myaccount = async (req, res) => {
  try {
    const user = await db.User.findByPk(req.userId);
    if (!user) return res.status(404).json({ success: false, message: 'User not found' });
    const data = user.toJSON();
    delete data.password;
    res.json({ success: true, user: data });
  } catch (err) {
    console.error(err);
    res.status(500).json({ success: false, message: 'Failed to fetch account' });
  }
};

exports.editaccount = [
  body('fname').optional().trim(),
  body('email').isEmail().normalizeEmail(),
  body('password').optional(),
  async (req, res) => {
    try {
      const errors = validationResult(req);
      if (!errors.isEmpty()) {
        return res.status(400).json({ success: false, errors: errors.array() });
      }
      const user = await db.User.findByPk(req.params.id);
      if (!user) return res.status(404).json({ success: false, message: 'User not found' });
      if (user.id !== req.userId) {
        return res.status(403).json({ success: false, message: 'Forbidden' });
      }

      const { fname, email, password } = req.body;
      const updateData = { fname: fname || user.fname, email };
      if (password) {
        updateData.password = await bcrypt.hash(password, 10);
      }
      await user.update(updateData);
      const data = user.toJSON();
      delete data.password;
      res.json({ success: true, user: data });
    } catch (err) {
      console.error(err);
      res.status(500).json({ success: false, message: 'Failed to update account' });
    }
  }
];
