const jwt = require('jsonwebtoken');
const config = require('../config');
const db = require('../models');

const verifyToken = (req, res, next) => {
  const authHeader = req.headers.authorization;
  const token = authHeader && authHeader.split(' ')[1];

  if (!token) {
    return res.status(401).json({ success: false, message: 'Access token required' });
  }

  try {
    const decoded = jwt.verify(token, config.jwtSecret);
    req.userId = decoded.userId;
    req.userType = decoded.type; // 'admin' | 'client'
    next();
  } catch (err) {
    return res.status(403).json({ success: false, message: 'Invalid or expired token' });
  }
};

const authAdmin = (req, res, next) => {
  verifyToken(req, res, () => {
    if (req.userType !== 'admin') {
      return res.status(403).json({ success: false, message: 'Admin access required' });
    }
    next();
  });
};

const authClient = (req, res, next) => {
  verifyToken(req, res, () => {
    if (req.userType !== 'client') {
      return res.status(403).json({ success: false, message: 'Client access required' });
    }
    next();
  });
};

const authOptional = (req, res, next) => {
  const authHeader = req.headers.authorization;
  const token = authHeader && authHeader.split(' ')[1];

  if (!token) {
    return next();
  }

  try {
    const decoded = jwt.verify(token, config.jwtSecret);
    req.userId = decoded.userId;
    req.userType = decoded.type;
  } catch (err) {
    // ignore
  }
  next();
};

module.exports = {
  verifyToken,
  authAdmin,
  authClient,
  authOptional
};
