'use strict';

module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.createTable('clients', {
      id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
      },
      ename: {
        type: Sequelize.STRING(255),
        allowNull: false
      },
      epassword: {
        type: Sequelize.STRING(255),
        allowNull: false
      },
      ephone: {
        type: Sequelize.STRING(50),
        allowNull: true
      },
      branch_id: {
        type: Sequelize.INTEGER,
        allowNull: true,
        references: { model: 'branches', key: 'id' },
        onUpdate: 'CASCADE',
        onDelete: 'SET NULL'
      },
      refid: {
        type: Sequelize.INTEGER,
        allowNull: true
      },
      app: {
        type: Sequelize.STRING(20),
        allowNull: false,
        defaultValue: 'RESTAFF'
      },
      status: {
        type: Sequelize.STRING(20),
        allowNull: false,
        defaultValue: 'offline'
      },
      user_id: {
        type: Sequelize.INTEGER,
        allowNull: true,
        references: { model: 'users', key: 'id' },
        onUpdate: 'CASCADE',
        onDelete: 'SET NULL'
      },
      created_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP')
      },
      updated_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP')
      }
    });
    await queryInterface.addIndex('clients', ['app'], { name: 'idx_app' });
    await queryInterface.addIndex('clients', ['branch_id'], { name: 'idx_branch_id' });
    await queryInterface.addIndex('clients', ['user_id'], { name: 'idx_user_id' });
    await queryInterface.addIndex('clients', ['refid'], { name: 'idx_refid' });
    await queryInterface.addIndex('clients', ['app', 'refid'], { name: 'idx_app_refid' });
  },

  async down(queryInterface) {
    await queryInterface.dropTable('clients');
  }
};
