'use strict';

module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.createTable('tbl_crc_logs', {
      id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
      },
      k: { type: Sequelize.STRING(255), allowNull: true },
      l: { type: Sequelize.STRING(255), allowNull: true },
      m: { type: Sequelize.STRING(255), allowNull: true },
      n: { type: Sequelize.STRING(255), allowNull: true },
      o: { type: Sequelize.STRING(255), allowNull: true },
      p: { type: Sequelize.STRING(255), allowNull: true },
      q: { type: Sequelize.STRING(255), allowNull: true },
      r: { type: Sequelize.STRING(255), allowNull: true },
      s: { type: Sequelize.TEXT, allowNull: true },
      t: { type: Sequelize.STRING(255), allowNull: true },
      client_id: {
        type: Sequelize.INTEGER,
        allowNull: true,
        references: { model: 'clients', key: 'id' },
        onUpdate: 'CASCADE',
        onDelete: 'SET NULL'
      },
      refid: {
        type: Sequelize.INTEGER,
        allowNull: true
      },
      attempt_datetime: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      w: { type: Sequelize.STRING(255), allowNull: true },
      x: { type: Sequelize.STRING(255), allowNull: true },
      created_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP')
      },
      updated_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP')
      }
    });
    await queryInterface.addIndex('tbl_crc_logs', ['refid'], { name: 'idx_refid' });
    await queryInterface.addIndex('tbl_crc_logs', ['client_id'], { name: 'idx_client_id' });
    await queryInterface.addIndex('tbl_crc_logs', ['k'], { name: 'idx_k' });
  },

  async down(queryInterface) {
    await queryInterface.dropTable('tbl_crc_logs');
  }
};
