'use strict';

module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.createTable('setting_excel', {
      id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
      },
      header_name: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      company_name: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      add_col_name: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      a: { type: Sequelize.STRING(255), allowNull: true },
      b: { type: Sequelize.STRING(255), allowNull: true },
      c: { type: Sequelize.STRING(255), allowNull: true },
      d: { type: Sequelize.STRING(255), allowNull: true },
      e: { type: Sequelize.STRING(255), allowNull: true },
      f: { type: Sequelize.STRING(255), allowNull: true },
      g: { type: Sequelize.STRING(255), allowNull: true },
      h: { type: Sequelize.STRING(255), allowNull: true },
      i: { type: Sequelize.STRING(255), allowNull: true },
      j: { type: Sequelize.STRING(255), allowNull: true },
      k: { type: Sequelize.STRING(255), allowNull: true },
      l: { type: Sequelize.STRING(255), allowNull: true },
      m: { type: Sequelize.STRING(255), allowNull: true },
      n: { type: Sequelize.STRING(255), allowNull: true },
      o: { type: Sequelize.STRING(255), allowNull: true },
      p: { type: Sequelize.STRING(255), allowNull: true },
      user_id: {
        type: Sequelize.INTEGER,
        allowNull: true,
        references: { model: 'users', key: 'id' },
        onUpdate: 'CASCADE',
        onDelete: 'SET NULL'
      },
      created_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP')
      },
      updated_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP')
      }
    });
    await queryInterface.addIndex('setting_excel', ['user_id'], { name: 'idx_user_id' });
    await queryInterface.addIndex('setting_excel', ['header_name'], { name: 'idx_header_name' });
  },

  async down(queryInterface) {
    await queryInterface.dropTable('setting_excel');
  }
};
