module.exports = (sequelize, DataTypes) => {
  const Import = sequelize.define('Import', {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    header_name: { type: DataTypes.STRING(255), allowNull: true },
    sr_no: { type: DataTypes.STRING(50), allowNull: true },
    acc_no: { type: DataTypes.STRING(100), allowNull: true },
    acc_date: { type: DataTypes.STRING(50), allowNull: true },
    code: { type: DataTypes.STRING(50), allowNull: true },
    customer_name: { type: DataTypes.STRING(255), allowNull: true },
    customer: { type: DataTypes.STRING(255), allowNull: true },
    advance: { type: DataTypes.STRING(100), allowNull: true },
    inquiry_office: { type: DataTypes.STRING(255), allowNull: true },
    cell_no: { type: DataTypes.STRING(50), allowNull: true },
    item_no: { type: DataTypes.STRING(100), allowNull: true },
    price: { type: DataTypes.STRING(100), allowNull: true },
    balance: { type: DataTypes.STRING(100), allowNull: true },
    installment: { type: DataTypes.STRING(100), allowNull: true },
    os: { type: DataTypes.STRING(100), allowNull: true },
    paid: { type: DataTypes.STRING(100), allowNull: true },
    unpaid: { type: DataTypes.STRING(100), allowNull: true },
    last_installment_date: { type: DataTypes.STRING(50), allowNull: true },
    p_installments: { type: DataTypes.STRING(100), allowNull: true },
    last_remarks: { type: DataTypes.TEXT, allowNull: true },
    remarks: { type: DataTypes.TEXT, allowNull: true },
    cr_action: { type: DataTypes.TEXT, allowNull: true },
    call_time: { type: DataTypes.STRING(100), allowNull: true },
    path: { type: DataTypes.STRING(255), allowNull: true },
    refid: { type: DataTypes.INTEGER, allowNull: true },
    user_id: { type: DataTypes.INTEGER, allowNull: true }
  }, {
    tableName: 'import',
    underscored: true,
    timestamps: false
  });
  return Import;
};
