const express = require('express');
const router = express.Router();
const authController = require('../controllers/authController');
const { authAdmin, authClient, verifyToken } = require('../middleware/auth');

router.post('/admin/login', authController.adminLogin);
router.post('/client/login', authController.clientLogin);
router.get('/me', verifyToken, authController.me);

module.exports = router;
