const express = require('express');
const router = express.Router();
const branchController = require('../controllers/branchController');
const { authAdmin } = require('../middleware/auth');

router.get('/list', authAdmin, branchController.list);
router.get('/:id', authAdmin, branchController.getBranch);
router.post('/add', authAdmin, branchController.add);
router.put('/edit/:id', authAdmin, branchController.edit);
router.delete('/del/:id', authAdmin, branchController.del);

module.exports = router;
