const express = require('express');
const router = express.Router();
const homeController = require('../controllers/homeController');
const { authAdmin } = require('../middleware/auth');

router.get('/', authAdmin, homeController.index);
router.get('/clients', authAdmin, homeController.clients);
router.get('/form', authAdmin, homeController.form);
router.get('/client/:id', authAdmin, homeController.getClient);
router.post('/add', authAdmin, homeController.add);
router.put('/edit/:id', authAdmin, homeController.edit);
router.delete('/del/:id', authAdmin, homeController.del);

module.exports = router;
