const express = require('express');
const router = express.Router();
const uploadController = require('../controllers/uploadController');
const { authAdmin } = require('../middleware/auth');

router.get('/', authAdmin, uploadController.index);
router.get('/branches', authAdmin, uploadController.branches);
router.get('/display', authAdmin, uploadController.display);
router.post('/save', authAdmin, uploadController.save);
router.post('/save_range', authAdmin, uploadController.saveRange);
router.post('/createExcel', authAdmin, uploadController.createExcel);
router.post('/del_branch', authAdmin, uploadController.delBranch);

module.exports = router;
